--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNpNetworkParams ""
(
  ---SECTION 1 - Local Variables
  local LOCobj
  local LOCpipeObj
  local LOCrelatedPipes   = #()
  local LOCrelatedStructs = #()

  ---SECTION 2 - Local Functions
  fn DYNFUNchangeTab FUNtab FUNobj =
  (
    local LOCoffset1, LOCoffset2, LOCoffset2p, LOCoffset2s, LOCoffset3
    LOCoffset1 = LOCoffset2 = LOCoffset2p = LOCoffset2s = LOCoffset3 = 0

    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = LOCoffset2p = LOCoffset2s = LOCoffset3 = -2000; DYNpNetworkParams.LBtabDescription.text = DYNuiResourcesLabels[123])
    if FUNtab == 2 then
    (
      LOCoffset2 = 0; LOCoffset1 = LOCoffset3 = -2000; DYNpNetworkParams.LBtabDescription.text = ""
      if classOf FUNobj.baseObject == Civil_Structure then LOCoffset2s = 0 else LOCoffset2s = -2000
      if classOf FUNobj.baseObject == CivilView_Pipe  then LOCoffset2p = 0 else LOCoffset2p = -2000
    )
    if FUNtab == 3 then (LOCoffset3 = 0; LOCoffset1 = LOCoffset2 = LOCoffset2p = LOCoffset2s = -2000; DYNpNetworkParams.LBtabDescription.text = "")

    --- Tab 1
    DYNpNetworkParams.GBDYN03.pos.x                   = LOCoffset1 + 13
    DYNpNetworkParams.LBDYNmodel01.pos.x              = LOCoffset1 + 22
    DYNpNetworkParams.LBDYNmodel02.pos.x              = LOCoffset1 + 27
    DYNpNetworkParams.LBDYNstring01.pos.x             = LOCoffset1 + 22
    DYNpNetworkParams.LBDYNstring02.pos.x             = LOCoffset1 + 27
    DYNpNetworkParams.GBDYN04.pos.x                   = LOCoffset1 + 13
    DYNpNetworkParams.LBDYNimported.pos.x             = LOCoffset1 + 27
    DYNpNetworkParams.GBDYN05.pos.x                   = LOCoffset1 + 13
    DYNpNetworkParams.LBDYNsource.pos.x               = LOCoffset1 + 22
    DYNpNetworkParams.LBDYNmodify01.pos.x             = LOCoffset1 + 22
    DYNpNetworkParams.LBDYNmodify02.pos.x             = LOCoffset1 + 27
    DYNpNetworkParams.BUDYNupdate.pos.x               = LOCoffset1 + 13

    --- Tab 2
    DYNpNetworkParams.dnPartData.pos.x                = LOCoffset2 + 14
    DYNpNetworkParams.GBDYN06.pos.x                   = LOCoffset2s + 13
    DYNpNetworkParams.DDDYNtype.pos.x                 = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNstruct_length.pos.x        = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNstruct_widthOrDia.pos.x    = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNstruct_height.pos.x        = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNfloor_thickness.pos.x      = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNwall_thickness.pos.x       = LOCoffset2s + 22
    DYNpNetworkParams.SPDYNstructure_length.pos.x     = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNstructure_widthOrDia.pos.x = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNstructure_height.pos.x     = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNfloor_thickness.pos.x      = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNwall_thickness.pos.x       = LOCoffset2s + 161

    DYNpNetworkParams.GBDYN07.pos.x                   = LOCoffset2s + 13
    DYNpNetworkParams.LBDYNframe_length.pos.x         = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNframe_widthOrDia.pos.x     = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNframe_height.pos.x         = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNrim_thickness.pos.x        = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNconcentric_offset_x.pos.x  = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNconcentric_offset_y.pos.x  = LOCoffset2s + 22
    DYNpNetworkParams.SPDYNframe_length.pos.x         = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNframe_widthOrDia.pos.x     = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNframe_height.pos.x         = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNrim_thickness.pos.x        = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNconcentric_offset_x.pos.x  = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNconcentric_offset_y.pos.x  = LOCoffset2s + 161

    DYNpNetworkParams.GBDYN08.pos.x                   = LOCoffset2s + 13
    DYNpNetworkParams.LBDYNcone_length.pos.x          = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNcone_widthOrDia.pos.x      = LOCoffset2s + 22
    DYNpNetworkParams.LBDYNcone_height.pos.x          = LOCoffset2s + 22
    DYNpNetworkParams.SPDYNcone_length.pos.x          = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNcone_widthOrDia.pos.x      = LOCoffset2s + 161
    DYNpNetworkParams.SPDYNcone_height.pos.x          = LOCoffset2s + 161

    DYNpNetworkParams.GBDYN09.pos.x                   = LOCoffset2p + 13
    DYNpNetworkParams.DDDYNpipeType.pos.x             = LOCoffset2p + 22
    DYNpNetworkParams.LBDYNpipe_widthOrDia.pos.x      = LOCoffset2p + 22
    DYNpNetworkParams.LBDYNpipe_height.pos.x          = LOCoffset2p + 22
    DYNpNetworkParams.LBDYNpipeWall_thickness.pos.x   = LOCoffset2p + 22
    DYNpNetworkParams.SPDYNpipe_widthOrDia.pos.x      = LOCoffset2p + 161
    DYNpNetworkParams.SPDYNpipe_height.pos.x          = LOCoffset2p + 161
    DYNpNetworkParams.SPDYNpipeWall_thickness.pos.x   = LOCoffset2p + 161

    --- Tab 3
    DYNpNetworkParams.LBDYNrelatedParts.pos.x         = LOCoffset3 + 14
    DYNpNetworkParams.dnNetwork.pos.x                 = LOCoffset3 + 14
    DYNpNetworkParams.BUDYNselectPipes.pos.x          = LOCoffset3 + 13
    DYNpNetworkParams.BUDYNselectStructs.pos.x        = LOCoffset3 + 13
    DYNpNetworkParams.BUDYNselectRelated.pos.x        = LOCoffset3 + 13
  )


  fn DYNFUNpNetworkParams FUNobj =
  (
    DYNpNetworkParams.LOCobj = FUNobj

    if (getAppData FUNobj 422) == "15" then
    (
      local LOCappData424                   = (getAppData FUNobj 424) as string
      DYNpNetworkParams.LBDYNmodel02.text   = DYNFUNdisplayAppDataInUI ((getAppData FUNobj 428) as string)
      DYNpNetworkParams.LBDYNstring02.text  = DYNFUNdisplayAppDataInUI ((getAppData FUNobj 427) as string)
      DYNpNetworkParams.LBDYNimported.text  = DYNFUNconvertGUPdate     ((getAppData FUNobj 425) as string)
      DYNpNetworkParams.LBDYNsource.text    = DYNFUNtrimPathName LOCappData424 141

      if doesFileExist LOCappData424 then
      (
        if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
        (
          --- For Model Files
          local LOCmodelName      = (getAppData FUNobj 428) as string; while LOCmodelName.count < 28 do LOCmodelName += " "
          local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCappData424 LOCmodelName
          DYNpNetworkParams.LBDYNmodify02.text  = if classOf LOCmxModelmodDate == string then DYNFUNconvertGUPdate LOCmxModelmodDate
        )
        else
        (
          --- For other file types
          DYNpNetworkParams.LBDYNmodify02.text  = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime LOCappData424 true)
        )
        if (findString DYNpNetworkParams.LBDYNmodify02.text DYNuiResourcesLabels[120]) != undefined then DYNpNetworkParams.LBDYNmodify02.text = "-" -- if created date is invalid
      )
      else
      (
        DYNpNetworkParams.LBDYNmodify02.text  = ""
      )

      DYNpNetworkParams.BUDYNupdate.enabled = if DYNpNetworkParams.LBDYNmodel02.text != "" then true else false

      --- Tab 2
      if classOf FUNobj.baseObject == Civil_Structure then
      (
        local LOCpartTypeStringAray = #(DYNuiResourcesLabels[604], DYNuiResourcesLabels[605], DYNuiResourcesLabels[606], DYNuiResourcesLabels[607], DYNuiResourcesLabels[608], DYNuiResourcesLabels[609], DYNuiResourcesLabels[610], DYNuiResourcesLabels[611], DYNuiResourcesLabels[612], DYNuiResourcesLabels[613])

        DYNpNetworkParams.dnRolloutTabCtrl.tabPages.item[1].text = FUNobj.displayName
        DYNpNetworkParams.dnPartData.Columns.item[0].text = FUNobj.partDesc
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[535] + ": " + (LOCpartTypeStringAray[FUNobj.partType + 1])); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[537] + ": " + FUNobj.partSizeName); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[538] + ": " + FUNobj.partSubType); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[534] + ": " + FUNobj.materialName); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[531] + ": " + FUNobj.cover); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[532] + ": " + FUNobj.frame); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[533] + ": " + FUNobj.grate); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[539] + ": " + (FUNobj.connectedPartCount as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[540] + ": " + (FUNobj.connectedPipesCount as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[553] + ": " + (FUNobj.barrelPipeClearance as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem

        if FUNobj.type >= 1 and FUNobj.type <= 2 then
        (
          DYNpNetworkParams.DDDYNtype.selection           = FUNobj.type
        )
        else
        (
          DYNpNetworkParams.DDDYNtype.selection           = 0
        )
        DYNpNetworkParams.SPDYNstructure_length.value     = FUNobj.structure_length
        DYNpNetworkParams.SPDYNstructure_widthOrDia.value = FUNobj.structure_widthOrDia
        DYNpNetworkParams.SPDYNstructure_height.value     = FUNobj.structure_height
        DYNpNetworkParams.SPDYNfloor_thickness.value      = FUNobj.floor_thickness
        DYNpNetworkParams.SPDYNwall_thickness.value       = FUNobj.wall_thickness
        DYNpNetworkParams.SPDYNframe_length.value         = FUNobj.frame_length
        DYNpNetworkParams.SPDYNframe_widthOrDia.value     = FUNobj.frame_widthOrDia
        DYNpNetworkParams.SPDYNframe_height.value         = FUNobj.frame_height
        DYNpNetworkParams.SPDYNrim_thickness.value        = FUNobj.rim_thickness
        DYNpNetworkParams.SPDYNconcentric_offset_x.value  = FUNobj.concentric_offset_x
        DYNpNetworkParams.SPDYNconcentric_offset_y.value  = FUNobj.concentric_offset_y
        DYNpNetworkParams.SPDYNcone_length.value          = FUNobj.cone_length
        DYNpNetworkParams.SPDYNcone_widthOrDia.value      = FUNobj.cone_widthOrDia
        DYNpNetworkParams.SPDYNcone_height.value          = FUNobj.cone_height
      )

      if classOf FUNobj.baseObject == CivilView_Pipe then
      (
        DYNpNetworkParams.LOCpipeObj = (CVGetMod FUNobj sweep)
        local LOCcrossSectionalShapeStringArray = #(DYNuiResourcesLabels[576], DYNuiResourcesLabels[577], DYNuiResourcesLabels[578], DYNuiResourcesLabels[579], DYNuiResourcesLabels[580], DYNuiResourcesLabels[581], DYNuiResourcesLabels[582], DYNuiResourcesLabels[583])
        local LOCpseTypeStringArray             = #(DYNuiResourcesLabels[584], DYNuiResourcesLabels[585], DYNuiResourcesLabels[586], DYNuiResourcesLabels[587])
        local LOCflowDirectionStringArray       = #(DYNuiResourcesLabels[588], DYNuiResourcesLabels[589], DYNuiResourcesLabels[590])
        local LOCflowDirectionMethodStringArray = #(DYNuiResourcesLabels[591], DYNuiResourcesLabels[592], DYNuiResourcesLabels[593], DYNuiResourcesLabels[594])

        DYNpNetworkParams.dnRolloutTabCtrl.tabPages.item[1].text = FUNobj.displayName
        DYNpNetworkParams.dnPartData.Columns.item[0].text = FUNobj.Description
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[558] + ": " + FUNobj.PartSizeName); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[559] + ": " + FUNobj.PartSubType); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[560] + ": " + (LOCpseTypeStringArray[FUNobj.PSEType + 1])); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[561] + ": " + (LOCflowDirectionStringArray[FUNobj.FlowDirection + 1])); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[562] + ": " + (LOCflowDirectionMethodStringArray[FUNobj.FlowDirectionMethod + 1])); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[563] + ": " + (FUNobj.Bearing as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[564] + ": " + (FUNobj.Radius as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[565] + ": " + (FUNobj.Slope as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[570] + ": " + (FUNobj.MinimumCover as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[571] + ": " + (FUNobj.MaximumCover as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[572] + ": " + (FUNobj.Length2DCenterToCenter as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[573] + ": " + (FUNobj.Length3DCenterToCenter as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[574] + ": " + (FUNobj.Length2DToInsideEdge as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[575] + ": " + (FUNobj.Length3DToInsideEdge as string)); DYNpNetworkParams.dnPartData.Items.Add LOClistItem


        local LOCpipeControlsEnabled = false
        local LOCcurrentBuiltInShape = 0
        if DYNpNetworkParams.LOCpipeObj != undefined then
        (
        /*
          ---------------- Sweep Modifier Built-In Sections --------------
          1  - Angle
          2  - Bar
          3  - Channel
          4  - Cylinder
          5  - Half Round
          6  - Pipe
          7  - Quarter Round
          8  - Tee
          9  - Tube
          10 - Wide Flange
          11 - Egg
          12 - Ellipse
          ----------------------------------------------------------------
        */

          LOCcurrentBuiltInShape = DYNpNetworkParams.LOCpipeObj.currentBuiltInShape

          if LOCcurrentBuiltInShape ==  6 then LOCpipeControlsEnabled = true -- circular pipes
          if LOCcurrentBuiltInShape ==  9 then LOCpipeControlsEnabled = true -- rectangular pipes
          if LOCcurrentBuiltInShape == 11 then LOCpipeControlsEnabled = true -- egg-shaped pipes
          if LOCcurrentBuiltInShape == 12 then LOCpipeControlsEnabled = true -- elliptical pipes
        )

        DYNpNetworkParams.DDDYNpipeType.enabled           = false
        DYNpNetworkParams.SPDYNpipe_widthOrDia.enabled    = LOCpipeControlsEnabled
        DYNpNetworkParams.SPDYNpipe_height.enabled        = LOCpipeControlsEnabled
        DYNpNetworkParams.SPDYNpipeWall_thickness.enabled = LOCpipeControlsEnabled
        DYNpNetworkParams.LBDYNpipe_widthOrDia.enabled    = LOCpipeControlsEnabled
        DYNpNetworkParams.LBDYNpipe_height.enabled        = LOCpipeControlsEnabled
        DYNpNetworkParams.LBDYNpipeWall_thickness.enabled = LOCpipeControlsEnabled

        DYNpNetworkParams.DDDYNpipeType.selection       = FUNobj.CrossSectionalShape + 1
        DYNpNetworkParams.SPDYNpipe_widthOrDia.value      = if LOCcurrentBuiltInShape == 11 or LOCcurrentBuiltInShape == 12 then FUNobj.InnerDiameterOrWidth else FUNobj.OuterDiameterOrWidth
        DYNpNetworkParams.SPDYNpipe_height.value          = if LOCcurrentBuiltInShape == 11 or LOCcurrentBuiltInShape == 12 then FUNobj.InnerHeight else FUNobj.OuterHeight
        DYNpNetworkParams.SPDYNpipeWall_thickness.value = (FUNobj.OuterDiameterOrWidth - FUNobj.InnerDiameterOrWidth) / 2.0
      )

      --- Show Related Parts
      DYNpNetworkParams.LOCrelatedPipes   = DynLXGetNodesByAppData #(428,(DYNpNetworkParams.LBDYNmodel02.text + "$!!$17$!!$HANDLE$!!$1")) "nodes"
      DYNpNetworkParams.LOCrelatedStructs = DynLXGetNodesByAppData #(428,(DYNpNetworkParams.LBDYNmodel02.text + "$!!$17$!!$HANDLE$!!$2")) "nodes"

      DYNpNetworkParams.dnNetwork.nodes.clear()

      local LOCrootNode   = DYNpNetworkParams.dnNetwork.nodes.add "[]" (DYNpNetworkParams.LBDYNmodel02.text + " (" + ((LOCrelatedPipes.count + LOCrelatedStructs.count) as string) + ")") 15 15
      local LOCstructNode = LOCrootNode.nodes.add "[structures]" (DYNuiResourcesLabels[525] + " (" + (LOCrelatedStructs.count as string) + ")") 37 37
      local LOCpipeNode   = LOCrootNode.nodes.add "[pipes]" (DYNuiResourcesLabels[524] + " (" + (LOCrelatedPipes.count as string) + ")") 37 37

      for i = 1 to LOCrelatedPipes.count   do (LOCpipeNode.nodes.add ("#|" + (i as string)) (getAppData LOCrelatedPipes[i] 427) 61 61)
      for i = 1 to LOCrelatedStructs.count do (LOCstructNode.nodes.add ("@|" + (i as string)) (getAppData LOCrelatedStructs[i] 427) 62 62)

      LOCrootNode.expand()
      LOCstructNode.expand()
      LOCpipeNode.expand()
    )
    else
    (
      DYNpNetworkParams.LBDYNmodel02.text   = DYNuiResourcesLabels[121]
      DYNpNetworkParams.LBDYNstring02.text  = DYNuiResourcesLabels[121]
      DYNpNetworkParams.LBDYNimported.text  = DYNuiResourcesLabels[121]
      DYNpNetworkParams.LBDYNsource.text    = DYNuiResourcesLabels[121]
      DYNpNetworkParams.LBDYNmodify02.text  = DYNuiResourcesLabels[121]
      DYNpNetworkParams.BUDYNupdate.enabled = false
    )
    DYNpNetworkParams.DYNFUNchangeTab 1 FUNobj
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[4,28] width:(DYNiniExplorerWidth - 21) height:563
  dotNetControl dnRolloutTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 23) pos:[5,12]
  label LBDYNspacer pos:[10,20]
  label LBtabDescription align:#center

  --- 1st Tab
  groupbox GBDYN03 width:(DYNiniExplorerWidth - 39) height:132 pos:[2013,57]
  label LBDYNmodel01  align:#left pos:[2022,76]
  label LBDYNmodel02  align:#left pos:[2027,94] width:(DYNiniExplorerWidth - 58) height:38
  label LBDYNstring01 align:#left pos:[2022,130]
  label LBDYNstring02 align:#left pos:[2027,148] width:(DYNiniExplorerWidth - 58) height:38

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 39) height:38 pos:[2013,193]
  label LBDYNimported align:#left pos:[2027,211] width:(DYNiniExplorerWidth - 57)

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 39) height:74 pos:[2013,236]
  label LBDYNsource align:#left pos:[2022,254] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify01 align:#left pos:[2022,272] width:(DYNiniExplorerWidth - 57)
  label LBDYNmodify02 align:#left pos:[2027,290] width:(DYNiniExplorerWidth - 57)

  button BUDYNupdate width:(DYNiniExplorerWidth - 39) pos:[2013,319]

  --- 2nd Tab
  dotNetControl dnPartData "System.Windows.Forms.ListView" height:145 width:(DYNiniExplorerWidth - 41) align:#center pos:[2014,42]

  --- 2nd Tab: Structures
  groupbox GBDYN06 width:(DYNiniExplorerWidth - 39) height:150 pos:[2013,192]
  dropdownlist DDDYNtype "" pos:[2022,211] width:(DYNiniExplorerWidth - 57)
  label LBDYNstruct_length width:130 pos:[2022,236]
  label LBDYNstruct_widthOrDia width:130 pos:[2022,257]
  label LBDYNstruct_height width:130 pos:[2022,278]
  label LBDYNfloor_thickness width:130 pos:[2022,299]
  label LBDYNwall_thickness width:130 pos:[2022,320]
  spinner SPDYNstructure_length "" range:[0,10000,300.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,236]
  spinner SPDYNstructure_widthOrDia "" range:[0,10000,400.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,257]
  spinner SPDYNstructure_height "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,278]
  spinner SPDYNfloor_thickness "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,299]
  spinner SPDYNwall_thickness "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,320]

  groupbox GBDYN07 width:(DYNiniExplorerWidth - 39) height:146 pos:[2013,347]
  label LBDYNframe_length  width:130 pos:[2022,366]
  label LBDYNframe_widthOrDia width:130 pos:[2022,387]
  label LBDYNframe_height  width:130 pos:[2022,408]
  label LBDYNrim_thickness width:130 pos:[2022,429]
  label LBDYNconcentric_offset_x width:130 pos:[2022,450]
  label LBDYNconcentric_offset_y width:130 pos:[2022,471]
  spinner SPDYNframe_length "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,366]
  spinner SPDYNframe_widthOrDia "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,387]
  spinner SPDYNframe_height "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,408]
  spinner SPDYNrim_thickness "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,429]
  spinner SPDYNconcentric_offset_x "" range:[-10000,10000,0.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,450]
  spinner SPDYNconcentric_offset_y "" range:[-10000,10000,0.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,471]

  groupbox GBDYN08 width:(DYNiniExplorerWidth - 39) height:83  pos:[2013,498]
  label LBDYNcone_length width:130 pos:[2022,517]
  label LBDYNcone_widthOrDia width:130 pos:[2022,538]
  label LBDYNcone_height width:130 pos:[2022,559]
  spinner SPDYNcone_length "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,517]
  spinner SPDYNcone_widthOrDia "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,538]
  spinner SPDYNcone_height "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,559]

  --- 2nd Tab: Pipes
  groupbox GBDYN09 width:(DYNiniExplorerWidth - 39) height:111 pos:[2013,192]
  dropdownlist DDDYNpipeType "" pos:[2022,211] width:(DYNiniExplorerWidth - 57)
  label LBDYNpipe_widthOrDia width:130 pos:[2022,236]
  label LBDYNpipe_height width:130 pos:[2022,257]
  label LBDYNpipeWall_thickness width:130 pos:[2022,278]
  spinner SPDYNpipe_widthOrDia "" range:[0,10000,400.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,236]
  spinner SPDYNpipe_height "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,257]
  spinner SPDYNpipeWall_thickness "" range:[0,10000,120.0] align:#right fieldwidth:40 type:#worldUnits pos:[2121,278]

  --- 3rd Tab
  label LBDYNrelatedParts align:#left pos:[2013,43] width:(DYNiniExplorerWidth - 57)
  dotNetControl dnNetwork "System.Windows.Forms.TreeView" height:451 width:(DYNiniExplorerWidth - 41) align:#center pos:[2014,60]
  button BUDYNselectPipes   width:(DYNiniExplorerWidth - 39) pos:[2013,516]
  button BUDYNselectStructs width:(DYNiniExplorerWidth - 39) pos:[2013,539]
  button BUDYNselectRelated width:(DYNiniExplorerWidth - 39) pos:[2013,562]

  on DYNpNetworkParams open do
  (
    DYNpNetworkParams.title       = DYNuiRolloutNames[67]

    GBDYN03.text                  = DYNuiResourcesGroups[33]
    GBDYN04.text                  = DYNuiResourcesGroups[34]
    GBDYN05.text                  = DYNuiResourcesGroups[7]
    GBDYN06.text                  = DYNuiResourcesGroups[145]
    GBDYN07.text                  = DYNuiResourcesGroups[146]
    GBDYN08.text                  = DYNuiResourcesGroups[147]
    GBDYN09.text                  = DYNuiResourcesGroups[148]

    BUDYNupdate.text              = DYNuiResourcesButtons[14]
    BUDYNselectPipes.text         = DYNuiResourcesButtons[116]
    BUDYNselectStructs.text       = DYNuiResourcesButtons[117]
    BUDYNselectRelated.text       = DYNuiResourcesButtons[118]

    LBtabDescription.text         = DYNuiResourcesLabels[123]
    LBDYNmodel01.text             = DYNuiResourcesLabels[51]
    LBDYNstring01.text            = DYNuiResourcesLabels[50]
    LBDYNmodify01.text            = DYNuiResourcesLabels[33]
    LBDYNrelatedParts.text        = DYNuiResourcesLabels[526]

    DDDYNtype.items               = #(DYNuiResourcesLabels[598], DYNuiResourcesLabels[599])
    LBDYNstruct_length.text       = DYNuiResourcesLabels[28]
    LBDYNstruct_widthOrDia.text   = DYNuiResourcesLabels[29]
    LBDYNstruct_height.text       = DYNuiResourcesLabels[30]
    LBDYNfloor_thickness.text     = DYNuiResourcesLabels[550]
    LBDYNwall_thickness.text      = DYNuiResourcesLabels[551]
    LBDYNframe_length.text        = DYNuiResourcesLabels[28]
    LBDYNframe_widthOrDia.text    = DYNuiResourcesLabels[29]
    LBDYNframe_height.text        = DYNuiResourcesLabels[30]
    LBDYNrim_thickness.text       = DYNuiResourcesLabels[552]
    LBDYNcone_length.text         = DYNuiResourcesLabels[28]
    LBDYNcone_widthOrDia.text     = DYNuiResourcesLabels[29]
    LBDYNcone_height.text         = DYNuiResourcesLabels[30]
    LBDYNconcentric_offset_x.text = DYNuiResourcesLabels[596]
    LBDYNconcentric_offset_y.text = DYNuiResourcesLabels[597]

    DDDYNpipeType.items           = #(DYNuiResourcesLabels[576], DYNuiResourcesLabels[577], DYNuiResourcesLabels[578], DYNuiResourcesLabels[579], DYNuiResourcesLabels[580], DYNuiResourcesLabels[581], DYNuiResourcesLabels[582], DYNuiResourcesLabels[583])
    LBDYNpipe_widthOrDia.text     = DYNuiResourcesLabels[568]
    LBDYNpipe_height.text         = DYNuiResourcesLabels[569]
    LBDYNpipeWall_thickness.text  = DYNuiResourcesLabels[551]

    local LOCtabNames             = #(DYNuiResourcesLabels[117], DYNuiResourcesLabels[527], DYNuiResourcesLabels[528])

    DYNFUNdnTreeViewStyle dnNetwork
    dnNetwork.imageList           = DYNdnSmImageList
    dnNetwork.sorted              = true

    DYNFUNdnListViewStyle dnPartData false true
    dnPartData.multiSelect        = false
    dnPartData.AllowColumnReorder = false
    dnPartData.sorting            = DYNdnSortOrderClass.none
    dnPartData.ShowItemToolTips   = true

    dnPartData.Columns.add "" 500

    dnRolloutTabCtrl.padding.x = 10
    for i = 1 to LOCtabNames.count do (dnRolloutTabCtrl.tabpages.add LOCtabNames[i])
  )

  on DYNpNetworkParams close do
  (
    LOCobj = undefined
    LOCpipeObj = undefined
    LOCrelatedPipes   = #()
    LOCrelatedStructs = #()
  )

  on dnRolloutTabCtrl mouseUp arg do
  (
    DYNFUNchangeTab (dnRolloutTabCtrl.selectedTab.TabIndex + 1) LOCobj
  )

  on BUDYNselectPipes   pressed do (select (LOCrelatedPipes))
  on BUDYNselectStructs pressed do (select (LOCrelatedStructs))
  on BUDYNselectRelated pressed do (select (LOCrelatedPipes + LOCrelatedStructs))

  on DDDYNtype                selected arg do LOCobj.type                 = arg
  on SPDYNstructure_length     changed arg do LOCobj.structure_length     = arg
  on SPDYNstructure_widthOrDia changed arg do LOCobj.structure_widthOrDia = arg
  on SPDYNstructure_height     changed arg do LOCobj.structure_height     = arg
  on SPDYNfloor_thickness      changed arg do LOCobj.floor_thickness      = arg
  on SPDYNwall_thickness       changed arg do LOCobj.wall_thickness       = arg
  on SPDYNframe_length         changed arg do LOCobj.frame_length         = arg
  on SPDYNframe_widthOrDia     changed arg do LOCobj.frame_widthOrDia     = arg
  on SPDYNframe_height         changed arg do LOCobj.frame_height         = arg
  on SPDYNrim_thickness        changed arg do LOCobj.rim_thickness        = arg
  on SPDYNconcentric_offset_x  changed arg do LOCobj.concentric_offset_x  = arg
  on SPDYNconcentric_offset_y  changed arg do LOCobj.concentric_offset_y  = arg
  on SPDYNcone_length          changed arg do LOCobj.cone_length          = arg
  on SPDYNcone_widthOrDia      changed arg do LOCobj.cone_widthOrDia      = arg
  on SPDYNcone_height          changed arg do LOCobj.cone_height          = arg
  /*
        6  - Pipe              .modifiers[#Sweep][#Pipe_Section]      .modifiers[#Sweep].shapes[7]
        7  - Quarter Round
        8  - Tee
        9  - Tube              .modifiers[#Sweep][#Tube_Section]      .modifiers[#Sweep].shapes[10]
        10 - Wide Flange
        11 - Egg               .modifiers[#Sweep][#Egg_Section]       .modifiers[#Sweep].shapes[12]
        12 - Ellipse           .modifiers[#Sweep][#Ellipse_Section]   .modifiers[#Sweep].shapes[13]
  */
  on SPDYNpipe_widthOrDia      changed arg do
  (
    if LOCpipeObj.currentBuiltInShape ==  6 then (LOCobj.OuterDiameterOrWidth = arg; LOCpipeObj.shapes[7].radius    = arg * 0.5; SPDYNpipe_height.value = arg; LOCobj.OuterHeight = arg)  -- circular pipes
    if LOCpipeObj.currentBuiltInShape ==  9 then (LOCobj.OuterDiameterOrWidth = arg; LOCpipeObj.shapes[10].width     = arg)         -- rectangular pipes
    if LOCpipeObj.currentBuiltInShape == 11 then (LOCobj.InnerDiameterOrWidth = arg; LOCpipeObj.shapes[12].egg_width  = arg; SPDYNpipe_height.value = LOCpipeObj.shapes[12].egg_length)     -- egg-shaped pipes
    if LOCpipeObj.currentBuiltInShape == 12 then (LOCobj.InnerDiameterOrWidth = arg; LOCpipeObj.shapes[13].width  = arg)         -- elliptical pipes
  )

  on SPDYNpipe_height          changed arg do
  (
    if LOCpipeObj.currentBuiltInShape ==  6 then (LOCobj.OuterHeight = arg; LOCpipeObj.shapes[7].radius     = arg * 0.5; SPDYNpipe_widthOrDia.value = arg; LOCobj.OuterDiameterOrWidth = arg) -- circular pipes
    if LOCpipeObj.currentBuiltInShape ==  9 then (LOCobj.OuterHeight = arg; LOCpipeObj.shapes[10].length     = arg)        -- rectangular pipes
    if LOCpipeObj.currentBuiltInShape == 11 then (LOCobj.InnerHeight = arg; LOCpipeObj.shapes[12].egg_length  = arg; SPDYNpipe_widthOrDia.value = LOCpipeObj.shapes[12].egg_width) -- egg-shaped pipes
    if LOCpipeObj.currentBuiltInShape == 12 then (LOCobj.InnerHeight = arg; LOCpipeObj.shapes[13].length  = arg)        -- elliptical pipes
  )

  on SPDYNpipeWall_thickness   changed arg do
  (
    if LOCpipeObj.currentBuiltInShape ==  6 then (LOCobj.InnerDiameterOrWidth = LOCobj.OuterDiameterOrWidth - (arg * 2.0); LOCpipeObj.shapes[7].pipe_thickness       = arg) -- circular pipes
    if LOCpipeObj.currentBuiltInShape ==  9 then (LOCobj.InnerDiameterOrWidth = LOCobj.OuterDiameterOrWidth - (arg * 2.0); LOCpipeObj.shapes[10].wrect_thickness      = arg) -- rectangular pipes
    if LOCpipeObj.currentBuiltInShape == 11 then (LOCobj.OuterDiameterOrWidth = LOCobj.InnerDiameterOrWidth + (arg * 2.0); LOCpipeObj.shapes[12].egg_thickness         = arg) -- egg-shaped pipes
    if LOCpipeObj.currentBuiltInShape == 12 then (LOCobj.OuterDiameterOrWidth = LOCobj.InnerDiameterOrWidth + (arg * 2.0); LOCpipeObj.shapes[13].ellipse_thickness = arg) -- elliptical pipes
  )

  on BUDYNupdate pressed do
  (
    local LOCgroupHeadNode
    if isGroupMember LOCobj then
    (
      if isValidNode LOCobj.parent then
      (
        LOCgroupHeadNode = LOCobj.parent

        if (querybox DYNuiResourcesQueries[90] title:DYNuiResourcesTitlebars[2]) then
        (
          if isOpenGroupHead LOCgroupHeadNode then setGroupOpen LOCgroupHeadNode false -- close the group if it is open
          APCFUNupdateImportedObjects #(LOCgroupHeadNode) true DYNtempPath
          APCFUNupdateAllPlacedObjectControllers()
        )
      )
      else
      (
        messagebox DYNuiResourcesErrorsWarnings[134] title:DYNuiResourcesTitlebars[1]
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[134] title:DYNuiResourcesTitlebars[1]
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBov3gcdB5eGR+fS4NpI/zGvRKz/nKS8Pec
-- BHE3uX9l97UYVWmsm1fqVbYTLqjaniRix4c5HfBHQ/2lRoxbNdRzaqEuYHU3B/aa
-- aEkXW2vfIQ11fwRYdrjSlfKFBnbB6SfVM3Dnr8B+RcUb0jLYtJr+OlGGZyoUjHzB
-- 4iKtEle/LFCh8+ThsC4X2RyZp+FnydytRdnHTEwDuIUkKUJx+gyFre1w4wYFcHFH
-- bWpb33Ou2h9l7Lc+wamGxtbZjwkZk/wrTobpzM3n+3xfPdNbtwWmz/pvfxeTy0Wz
-- ypNzbtLZkpH9BdZ9TGE1wNazMFqyZq85axHBIjYSlnq1dHpi4Ccp
-- -----END-SIGNATURE-----